//Dynare set-up:  GK-NK Model with costs of adjusting investment, habit and indexing
//With JR Preferences and a Frisch Elasticity Target
//With flexi-price bloc and output gap
// Original solution to GK banker's problem
//(c) CIMS Univeristy of Surrey
//The Science and  Art of DSGE Modelling: Construction, Calibration, Estimation and Policy
//////////////////////////////////////////////////////////////////////////////////////////////////
//This is a free software: you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation, either version 3 of the License, or (at your option)
// any later version.  See <http://www.gnu.org/licenses/> for more information.
//////////////////////////////////////////////////////////////////////////////////////////////////
@#define MPR=1
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Choose whether MPR is on (MPR=1) else  no MPR  
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

@#define form_of_habits=1
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%Choose the form of habits%%
%%external=1; else internal%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@#define wagesticky = 1
%
% wagesticky = 1 gives sticky wages
% wagesticky = 0 gives flexi wages
%
%
@#define form_of_indexing= 0
%
%form_of_indexing= 1 gives indexing of wages and prices in the steady state (as in SW07)
%form_of_indexing= 0 gives no indexing of wages and prices in the steady state
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

@#define rule = 1
%rule=0  gives  implementable rule with persistence, inflation and output targets
%rule=1  gives  standard Taylor  rule with persistence, inflation and output gap targets
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%DECLARATION OF ENDOGENOUS VARIABLES%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
var U UC UH R LAMBDA RK C  W H Hd Y YW PWP K  I  
 A G   KYW IY CY
S Sdash Q X Rn ER  PIE  MC 
JJp  Jp  PIEtilde Deltap PO
Wh Jw JJw PIEw  Deltaw WO  PIEwptilde PIEwtilde Invmarkup
MCS  MRSS MPS RPS IS KQ Sasset phiB N D nud spread mus omega 
xequity lambda q E Re Thetax DThetax mue lever
xiB thetaFF kappaFF g bettag 
Xi UXi lam mu  kappa Frisch  theta CEquiv Omega epsAtrendstate
rhoH F  F1 GG AA B CCC
UCF CF HF UHF UXiF lamF RF muF WF YF KF QF LAMBDAF SF SdashF XF 
XiF RKF IF kappaF CYF IYF KYF OUTGAP;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%DECLARATION OF EXOGENOUS VARIABLES%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
varexo epsA epsG epsMC epsMPS  epsIS  epsAtrend  epsMRSS epsRPS epsKQ;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%DECLARATION OF PARAMETERS%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
parameters gy  alp  zzeta betta delta  sigma_c   sigma_s rhoA rhoG phiX
xip xiw  rho_r theta_pie theta_y theta_dy rhoMC rhoMRSS rhoMPS rhoIS rhoRPS rhoKQ chi
 gammap gammaw   A_bar H_bar PIE_bar habit
sigmaB  spreadtarg levtarg epsilon xequitytarg g_bar
cy  gam  Frischtarget index wage muw
rho_lever lever_y lever_spread; 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%CALIBRATION OF PARAMETERS%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
levtarg=4;
spreadtarg=0.01/4;
sigmaB=0.9688;
xequitytarg=0.15;
epsilon=-2;

PIE_bar=1.01;
H_bar=0.33;
g_bar=0.005;

@#if  form_of_indexing==1
%indexing of wages and prices in the steady state (as in SW07)
% 
index=1;
@#else
%indexing of wages and prices in the steady state 
index=0;
@#endif


gammap=0.5;
gammaw=0.5; 
chi=0.7;
phiX=2.0;
gy=0.18;
alp=0.67;
zzeta=7.0;
betta=0.99;
delta=0.0250;
sigma_c=1.5;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% JR References Block
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
Frischtarget=2.5;//Central calibration from literature

gam=0.004;//Minimal value for ss solution with rhoH<1
gam=1.0;//KPR Case
gam=0.5;//prior for estimation
cy=0.6;
%

%
%Choice of Units
%
A_bar=1;
%
%shock persistence
%
rhoA=0.75;
rhoG=0.75;
rhoMC=0.75;
rhoMRSS=0.75;
rhoMPS=0.75;
rhoRPS=0.75;
rhoIS=0.75;
rhoKQ=0.75;

xip=0.75; 
xiw=0.75; 
%
%Monetary Policy Rule Feedback
%
rho_r=0.7;
theta_pie=1.5;
theta_y=0.3;
theta_dy=0.3;
%
%scale sd of shocks; 1 for irfs and order 1; 0.01 for second moments and order 2  
%
sigma_s=0.01;

@#if  form_of_habits==1
%
%external habit
%
habit=1;
@#else  
%internal habit
%
habit=0;

@#endif

@#if wagesticky >0
wage=1;
 xiw=0.75;
muw=3;
@#else
wage=0;
xiw=0;
muw=1000;
@#endif

%%%%%%%%%%%%%%%%%%%%%
%MPR rule
%%%%%%%%%%%%%%%%%%55
rho_lever=0.7;
%
%Weak Regulation
%
lever_y=0.1;
lever_spread=0.1;
%
lever_y=0.3;
lever_spread=0.3;
%
%lever_y=0.5;
%lever_spread=0.5;
%
%Strong Regulation
%
%lever_y=1;
%lever_spread=1;
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% ----------------------------
% *** DSGE-Model-equations ***
% ----------------------------
model;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%Frisch Inverse Elasticity 
%NOTATION is slightly changed from Holden et al (2018): varrho is that paper becomes kappa here and 1+psi becomes theta 
%
%
%
rhoH=kappa*H_bar^theta;
F=(1-rhoH*gam);
F1=(1-rhoH);
GG=rhoH;
AA=-gam+sigma_c*F/F1;
B=(sigma_c*theta*GG+(theta-1)*F1)/(sigma_c*F-gam*F1);
CCC=theta*GG*(sigma_c*F-gam*F1)/(sigma_c*F^2+gam*(gam-1)*GG*F1*(1+1/(1-bettag*(1-gam))));
Frisch=AA*(B-CCC);
%
%Check Leisure is a normal good if checknormalgood>0 where
%checknormalgood=kappa*H_bar^theta+theta-1; now removed
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%
%Growth in A
%%%%%%%%%%%%%%%%%%%%%%%%%
log(1+g)=log(1+g_bar)+epsAtrend;
%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Household Problem with JR Preferences
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

kappa=STEADY_STATE(kappa);
kappaF=STEADY_STATE(kappaF);
theta=STEADY_STATE(theta);

bettag=betta*(1+g)^(-sigma_c);

%%%%%%%%%%%%%%%%%%%%%%%%%
%%Single period utility%%
%%%%%%%%%%%%%%%%%%%%%%%%%

U=((C-chi*C(-1)/(1+g)-kappa*(H^theta)*Xi)^(1-sigma_c)-1)/(1-sigma_c);
%Xi=(C-chi*C(-1)/(1+g))^gam*Xi(-1)^(1-gam);
Xi=(C-chi*C(-1)/(1+g))^gam*(Xi(-1)/(1+g))^(1-gam);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%CE Calculation
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
CEquiv=((1.01*(C-chi*C(-1)/(1+g))-kappa*(H^theta)*Xi)^(1-sigma_c)-1)/(1-sigma_c)-U+(1+g(+1))*bettag(+1)*CEquiv(+1);

%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%Intertemporal welfare
%%%%%%%%%%%%%%%%%%%%%%%%%%%
%First define a state=exog shock because dynare cannot have a lead of lag of an exog shock
epsAtrendstate=epsAtrend;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
Omega=U+betta*(1+g_bar)^(1-sigma_c)*exp((1-sigma_c)*epsAtrendstate(+1))*Omega(+1);
%


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%Marginal utility of consumption%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
UC=(C-chi*C(-1)/(1+g)-kappa*H^theta*Xi)^(-sigma_c);
UH=-theta*kappa*H^(theta-1)*Xi*UC;
UXi=-kappa*H^theta*UC;

%%%%%%%%%%%%%%%%%
%%Euler equation
%%%%%%%%%%%%%%%%%

lam=bettag*R(+1)*RPS*lam(+1);

@#if  form_of_habits==1
%
%external habit
%
lam=UC-gam*mu*Xi/(C-chi*C(-1)/(1+g));
@#else  
%internal habit 
lam=UC-bettag(+1)*chi*UC(+1)-gam*mu*Xi/(C-chi*C(-1)/(1+g))
+bettag(+1)*chi*gam*mu(+1)*Xi(+1)/(C(+1)-chi*C/(1+g(+1)));
%
@#endif
mu=-UXi+bettag(+1)*(1+g(+1))*(1-gam)*mu(+1)*Xi(+1)/Xi;

%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%Labour supply foc    %%
%%%%%%%%%%%%%%%%%%%%%%%%%%%
-UH/lam=Wh;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%Fisher Equation
%
R=Rn(-1)/PIE;
ER=Rn/PIE(+1);
%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%Wholesale and retail sector relation%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
Y=YW/Deltap;
Hd=H/Deltaw;

%%%%%%%%%%%%%%%%%%%%%%%
%%Production Function%%
%%%%%%%%%%%%%%%%%%%%%%%
%
%Note: Capital stock is end-of-period
%
YW=((A*Hd)^alp)*(K(-1)/(1+g))^(1-alp);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%Household Investmen FOC and Wholesale firms Labour demand FOC%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
RK=KQ*((1-alp)*PWP*YW/(K(-1)/(1+g))+(1-delta)*Q)/Q(-1);
%
%where Tobin's Q is given by
%
%Stochastic Discount Factor
%
LAMBDA=bettag*lam/lam(-1);
%
Q*IS*(1-S-X*Sdash)+LAMBDA(+1)*Q(+1)*IS(+1)*Sdash(+1)*X(+1)^2=1;
%
PWP*(alp*YW)/Hd=W;
%
%%%%%%%%%%%%%%%%%%%%%%%%%
%%Capital law of motion%% 
%%%%%%%%%%%%%%%%%%%%%%%%%
%
K=KQ(+1)*((1-S)*I*IS+(1-delta)*K(-1)/(1+g));
%
%where
%
X=I*(1+g)/I(-1);
S=phiX*(X-1-g)^2;
Sdash=2*phiX*(X-1-g);
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
%In NK we had 
%LAMBDA(+1)*RK(+1)=1;
%
%Banking Model with friction replaces this arbitrage condition with
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%Banking Model
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
thetaFF=STEADY_STATE(thetaFF);
xiB=STEADY_STATE(xiB);
kappaFF=STEADY_STATE(kappaFF);



Sasset=K;   
Q*Sasset=phiB*N;
lever=Q*Sasset/(N+q*E);
xequity=E*q/(Q*Sasset);
phiB=nud/(Thetax-(mus+mue*xequity));
Thetax=thetaFF*(1+epsilon*xequity+kappaFF*xequity^2/2);
DThetax=thetaFF*(epsilon+kappaFF*xequity);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%MPR Rule on or off
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@#if MPR==1
  @#if rule == 0
  %
  log(lever/STEADY_STATE(lever))=rho_lever*log(lever(-1)/STEADY_STATE(lever))
  -lever_y*log(Y/STEADY_STATE(Y))+lever_spread*log((1+spread)/(1+STEADY_STATE(spread)));
  @#else
  log(lever/STEADY_STATE(lever))=rho_lever*log(lever(-1)/STEADY_STATE(lever))
  -lever_y*log((Y/STEADY_STATE(Y))/(YF/STEADY_STATE(YF)))+lever_spread*log((1+spread)/(1+STEADY_STATE(spread)));
@#endif
@#else
(1+lambda)*mue=DThetax*lambda;
@#endif
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

(1+lambda)*(mus+mue*xequity)=Thetax*lambda;
(1+g)*N=(sigmaB+xiB)*RK*Sasset(-1)*Q(-1)-sigmaB*Re*E(-1)*q(-1)-R*sigmaB*D(-1);
D=Q*Sasset-N-q*E;
nud=LAMBDA(+1)*omega(+1)*(R(+1));
mus=LAMBDA(+1)*omega(+1)*spread(+1);
omega=1-sigmaB+sigmaB*Thetax*phiB;
Re=((1-alp)*PWP*YW/(K(-1)/(1+g))+(1-delta)*q)/q(-1);
mue=LAMBDA(+1)*omega(+1)*(R(+1)-Re(+1));
LAMBDA(+1)*R(+1)=LAMBDA(+1)*Re(+1);
spread=RK-R;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%End of Banking Model- rest is as for NK
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%



%%%%%%%%%%%%%%%%%%%%%%%
%%Outpur Market Equilibrium%%
%%%%%%%%%%%%%%%%%%%%%%%
Y=C+G+I;



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%Price Inflation Dynamics and Price Dispersion%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
JJp-xip*LAMBDA(+1)*PIEtilde(+1)^(zzeta-1)*JJp(+1)*(1+g(+1))=Y;
Jp-xip*LAMBDA(+1)*PIEtilde(+1)^zzeta*Jp(+1)*(1+g(+1))=(1/(1-1/zzeta))*Y*MC*MCS;
@# if form_of_indexing ==1
PIEtilde=(PIE/PIE(-1)^gammap)/STEADY_STATE(PIE)^(1-gammap);// Complete indexing in ss
@#else
PIEtilde=(PIE/PIE(-1)^gammap);// No indexing in ss
@#endif
PO=Jp/JJp;
1=xip*PIEtilde^(zzeta-1)+(1-xip)*(PO)^(1-zzeta);
Deltap=xip*(PIEtilde^zzeta)*Deltap(-1)+(1-xip)*PO^(-zzeta);
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%Wage Inflation Dynamics and Wage Dispersion 36-38%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
@#if wagesticky > 0
PIEw=(1+g)*PIE*W/W(-1);
@# if form_of_indexing ==1
PIEwtilde=PIEw/PIE(-1)^gammaw/STEADY_STATE(PIE)^(1-gammaw);//Complete indexing in ss;
PIEwptilde=PIE/PIE(-1)^gammaw/STEADY_STATE(PIE)^(1-gammaw);//Complete indexing in ss;
@#else
PIEwtilde=PIEw/PIE(-1)^gammaw;//no indexing in ss;
PIEwptilde=PIE/PIE(-1)^gammaw;//no indexing in ss;
@#endif
JJw-xiw*LAMBDA(+1)*PIEwtilde(+1)^(muw)/PIEwptilde(+1)*JJw(+1)=Hd;
%
%eqn 70
%
Jw-xiw*LAMBDA(+1)*PIEwtilde(+1)^muw*Jw(+1)*(1+g(+1))=(1/(1-1/muw))*Hd*Wh*MRSS;
%
%

WO=Jw/(W*JJw);
1=xiw*(PIEw*PIEwptilde/PIE)^(muw-1)+(1-xiw)*WO^(1-muw);
Deltaw=xiw*(PIEwtilde^muw)*Deltaw(-1)+(1-xiw)*WO^(-muw);
Invmarkup=Wh/W;
@#else
PIEw=(1+g)*PIE*W/W(-1);
JJw=Hd;
Jw=Hd*Wh*MRSS;
%PIEwtilde=PIEw/PIE(-1)^gammaw/STEADY_STATE(PIE)^(1-gammaw);//Complete indexing in ss;
%PIEwptilde=PIE/PIE(-1)^gammaw/STEADY_STATE(PIE)^(1-gammaw);//Complete indexing in ss;
PIEwtilde=PIEw/PIE(-1)^gammaw;//No indexing in ss;
PIEwptilde=PIE/PIE(-1)^gammaw;//No indexing in ss;
%W=(1/(1-(1/mu)))*Wh*MRSS;
W=Wh*MRSS;
Deltaw=1;
WO=Jw/(W*JJw);
Invmarkup=Wh/W;
@#endif

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%RBC (Flexi-price and wage) Model for output here
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%Marginal utility of consumption eqn 75-78%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
XiF=(CF-chi*CF(-1)/(1+g))^gam*(XiF(-1)/(1+g))^(1-gam);
UCF=(CF-chi*CF(-1)/(1+g)-kappaF*HF^theta*XiF)^(-sigma_c);
UHF=-theta*kappaF*HF^(theta-1)*XiF*UCF;
UXiF=-kappaF*HF^theta*UCF;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%Euler real equation without Risk Premium Shock%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

lamF=bettag(+1)*RF*lamF(+1);
%
@#if  form_of_habits==1
%
%external habit
%
lamF=UCF-gam*muF*XiF/(CF-chi*CF(-1)/(1+g));
@#else  
%internal habit -eqn 81
lamF=UCF-bettag(+1)*chi*UCF(+1)-gam*muF*XiF/(CF-chi*CF(-1)/(1+g))
+bettag(+1)*chi*gam*muF(+1)*XiF(+1)/(CF(+1)-chi*CF/(1+g(+1)));
%
@#endif
muF=-UXiF+bettag(+1)*(1+g(+1))*(1-gam)*muF(+1)*XiF(+1)/XiF;

%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%Labour supply foc eqs 82-84
%%%%%%%%%%%%%%%%%%%%%%%%%%%
-UHF/lamF=WF;
%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%Fisher Equation not needed for real only model
%

%%%%%%%%%%%%%%%%%%%%%%%
%%Production Function%%
%%%%%%%%%%%%%%%%%%%%%%%
%
%Note: Capital stock is end-of-period
%
YF=((A*HF)^alp)*(KF(-1)/(1+g))^(1-alp);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%Household Investment FOC and Wholesale firms Labour demand FOC%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
RKF=((1-alp)*YF/(KF(-1)/(1+g))+(1-delta)*QF)/QF(-1);
%
%where Tobin's QF is given by
%
%Stochastic Discount Factor
%
LAMBDAF=bettag*lamF/lamF(-1);
%
IS*QF*(1-SF-XF*SdashF)+LAMBDAF(+1)*QF(+1)*IS(+1)*SdashF(+1)*XF(+1)^2=1;
% eqn 87
alp*YF/HF=WF;
%%%%%%%%%%%%%%%%%%%%%%%%%
%%Capital law of motion%% 
%%%%%%%%%%%%%%%%%%%%%%%%%
%
KF=(1-SF)*IF*IS+(1-delta)*KF(-1)/(1+g);
%
%where
%

XF=IF*(1+g)/IF(-1);
SF=phiX*(XF-1-g)^2;
SdashF=2*phiX*(XF-1-g);
%%%%%%%%%%%
%Arbitrage 
%%%%%%%%%%%  
LAMBDAF(+1)*RKF(+1)=1;

%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%Output Market Equilibrium%%% eqn 93
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
YF=CF+G+IF;
%%%%%%%%%%%%%%%
%OUTPUT GAP
%%%%%%%%%%%%%
OUTGAP=Y/YF;
%

@#if rule == 0
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%Taylor rule - implementable rule (relative to ss)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
log(Rn/STEADY_STATE(Rn))=rho_r*log(Rn(-1)/STEADY_STATE(Rn))+(1-rho_r)*(theta_pie*log(PIE/STEADY_STATE(PIE))
+theta_y*log(Y/STEADY_STATE(Y))+theta_dy*log(Y/Y(-1)))+epsMPS;
@#else
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%Standard Taylor rule (relative to Flexi-Price )
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
log(Rn/STEADY_STATE(Rn))=rho_r*log(Rn(-1)/STEADY_STATE(Rn))+(1-rho_r)*(theta_pie*log(PIE/STEADY_STATE(PIE))
+theta_y*log((Y/STEADY_STATE(Y))/(YF/STEADY_STATE(YF)))+ 
theta_dy*(log((Y/STEADY_STATE(Y))/(YF/STEADY_STATE(YF)))-log((Y(-1)/STEADY_STATE(Y))/(YF(-1)/STEADY_STATE(YF)))))+epsMPS;
%
@#endif

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%Mark-up Monopolistic pricing%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 

MC=PWP;

%%%%%%%%%%%%%%%%%%%
%%Shock processes%%
%%%%%%%%%%%%%%%%%%%
log(A)-log(STEADY_STATE(A))=rhoA*(log(A(-1))-log(STEADY_STATE(A)))+epsA;
log(G)-log(STEADY_STATE(G))=rhoG*(log(G(-1))-log(STEADY_STATE(G)))+epsG;
log(MCS)-log(STEADY_STATE(MCS))=rhoMC*(log(MCS(-1))-log(STEADY_STATE(MCS)))+epsMC;
log(MRSS)-log(STEADY_STATE(MRSS))=rhoMRSS*(log(MRSS(-1))-log(STEADY_STATE(MRSS)))+epsMRSS;
log(IS)-log(STEADY_STATE(IS))=rhoIS*(log(IS(-1))-log(STEADY_STATE(IS)))+epsIS;
log(MPS)-log(STEADY_STATE(MPS))=rhoMPS*(log(MPS(-1))-log(STEADY_STATE(MPS)))+epsMPS;
log(RPS)-log(STEADY_STATE(RPS))=rhoRPS*(log(RPS(-1))-log(STEADY_STATE(RPS)))+epsRPS;
log(KQ)-log(STEADY_STATE(KQ))=rhoKQ*(log(KQ(-1))-log(STEADY_STATE(KQ)))+epsKQ;



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%Variables used in steady state
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
KYW=K/YW;
IY=I/Y;
CY=C/Y;
CYF=CF/YF;
IYF=IF/YF;
KYF=KF/YF;

end;


steady;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%SPECIFICATION OF SHOCKS for first order and irfs%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

shocks;
var epsA; stderr sigma_s;
var epsAtrend; stderr sigma_s;
var epsG; stderr sigma_s;
var epsMC; stderr sigma_s ;
var epsMPS; stderr sigma_s ;
var epsMRSS; stderr sigma_s ;
var epsRPS; stderr sigma_s ;
var epsIS; stderr sigma_s;
var epsKQ; stderr sigma_s;
end;



check;


stoch_simul(order=2,pruning, irf=0)  Y C I H Hd W R Q Rn PIE  RK spread N  Omega E OUTGAP lever;
